
### Mechanisms for Applying Group Policies

- **Default Group Policy on Connection Profile**
    - Group policy is applied to a connection profile as its default group policy.
- **Per-User Policy on Local User Profiles (ASA)**
    - On Cisco Secure Firewall ASA, group policy can be assigned directly to individual user profiles if local authentication is used.
- **Group Policy Pushed from AAA RADIUS Server**
    - Group policy can be pushed by an external AAA RADIUS server during authentication/authorization.
    - Group policy must be defined locally on the VPN headend device.
    - AAA server provides the group policy name via the **RADIUS Class attribute (#25)**.

### Reusability and Simplified Configuration

- Group policies are reusable across multiple connection profiles or user profiles.
- Enables streamlined deployment of similar policies to various users or groups.

---

## Example Configuration

- Three connection profiles and three group policies configured.
    - Two users connect via ENTERPRISE-PROFILE and are assigned EMPLOYEES-POLICY by default.
    - The second user, with a per-user policy, is assigned IT-POLICY instead.
    - Other users use different connection profiles but share the PARTNER-POLICY group policy.

---

## Default Group Policy: DfltGrpPolicy

- **Existence & Customization**
    - Both Cisco Secure Firewall ASA and Threat Defense have a default group policy called DfltGrpPolicy.
    - DfltGrpPolicy is assigned by default to the DefaultWEBVPNGroup connection profile.
    - DfltGrpPolicy cannot be deleted but can be customized.
    - You can disassociate DfltGrpPolicy from default profiles and attach a different group policy if needed.
- **Role in Policy Inheritance**
    - DfltGrpPolicy supports policy inheritance.
    - Custom policies can inherit parameters from DfltGrpPolicy when not explicitly set.
    - Proper configuration of DfltGrpPolicy is important, especially in large or complex environments.

---

## Group Policy Settings

- Cisco Secure Firewall Threat Defense and ASA offer nearly the same group policy attributes.
- Settings are organized differently on each platform.